package book.beans;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.RequestScoped;
import javax.faces.event.AjaxBehaviorEvent;
import javax.inject.Named;

/**
 *
 * @author Leonard
 */
@Named
@RequestScoped
public class AjaxBean {
    
    private static final Logger logger =
            Logger.getLogger(AjaxBean.class.getName());
    private String name = "brak";

    public String getName() {
        return name;
    }

    public void setName(String name) {
        logger.log (Level.INFO, "Imię: {0}", name);
        this.name = name;
    }
    
    public void upperCaseName(){
        logger.log (Level.INFO, "Metoda nasłuchująca AJAX bez AjaxBehaviorEvent oraz atrybutu action");
        name = name.toUpperCase();
        logger.log (Level.INFO, "Imię: {0}", name);
    }
    
    public void upperCaseNameABE(AjaxBehaviorEvent event){         
        logger.log (Level.INFO, "Metoda nasłuchująca AJAX a argumentem AjaxBehaviorEvent");
        name = name.toUpperCase();
        logger.log (Level.INFO, "Imię: {0}", name);
    }
    
}
